import cv2
import os
import datetime
import tkinter as tk
from tkinter import Label, Button, filedialog, messagebox
from PIL import Image, ImageTk
name = ""
# Set the desired dimensions of the window



class PhotoBoothApp:
    def __init__(self, output_path):
        self.output_path = output_path
        self.window = tk.Tk()
        self.window.title("Photo Booth")

    # Set window width    
        self.window_width = 1024
        self.window_height = 768
        
        self.center_window()
        
    # Function to center the window
    def center_window(self):
        # Get the screen width and height
        self.screen_width = self.window.winfo_screenwidth()
        self.screen_height = self.window.winfo_screenheight()

        # Calculate x and y coordinates for the window
        self.x_coordinate = int((self.screen_width / 2) - (self.window_width / 2))
        self.y_coordinate = int((self.screen_height / 2) - (self.window_height / 2))

        # Set the geometry of the window
        self.window.geometry(f"{self.window_width}x{self.window_height}+{self.x_coordinate}+{self.y_coordinate}")

        # Call the function to center the window
    
        
              

        # Bind the Escape key to the exit function
        self.window.bind("<Escape>", self.exit_app)
        # Bind the Enter key to save 
        self.window.bind("<Return>",self.save_image)
        
        
        # Initialize video capture default 640 x 480
        
        #self.video_source = 0  # Change this if you have multiple cameras
        #self.vid = cv2.VideoCapture(self.video_source)
        
        
        # Initialize video capture custom size 
        cap = cv2.VideoCapture(0)
        cap.set(3, 800)
        cap.set(4, 600)       
        self.vid = cap

        # Create a label for video feed
        self.video_label = Label(self.window)
        self.video_label.pack()
        
        # Label
        label = tk.Label(self.window, text="Enter Member ID:")
        label.pack()
            
        #file name
        self.filename_entry = tk.Entry(self.window, width=15)
        self.filename_entry.pack(pady=10)        

        # Set focus on the Entry widget
        self.filename_entry.focus_set()

        # Capture button

        self.capture_button = Button(self.window, text="Capture", command=self.save_image)
        self.capture_button.pack(side=tk.TOP)
        # Create an exit button
        self.exit_button = Button(self.window, text="EXIT", command=self.exit_button, fg="red", font=("Aerial", 20))
        self.exit_button.place(x=920, y=700)  # Position 
        
        
        #self.exit_button.pack(side=tk.RIGHT)
        


        self.update()
        self.window.mainloop()
        

    def update(self):        
        
        ret, frame = self.vid.read()
        if ret:
            # Convert the frame to RGB format and then to ImageTk format
            frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
            img = Image.fromarray(frame)
            imgtk = ImageTk.PhotoImage(image=img)
            self.video_label.imgtk = imgtk
            self.video_label.configure(image=imgtk)
        
        # Call this function again after 10 ms
        self.window.after(10, self.update)

        
    def save_image(self, event):
        filename = self.filename_entry.get()
        ret, frame = self.vid.read()
        if filename:        
            # Save the currently displayed image
            pic_name = (f"{filename}.png")          
            #cv2.imwrite(f"{filename}.png", frame)            
            full_path = os.path.join(photo_path, pic_name)
            cv2.imwrite(full_path, frame)
            
            messagebox.showinfo("Saved", f"Image saved as {filename}.png")
            self.filename_entry.delete(0, tk.END)              
            #print(f"Image saved as {filename}.png")
        else:
            messagebox.showinfo("Please enter member ID", "Member ID Required!!")
                   
                   
    def exit_app(self, event):
        """Close the application."""
        self.vid.release()        
        self.window.destroy()

    def exit_button(self):
        """Close the application."""
        self.vid.release()        
        self.window.destroy()



    def __del__(self):
        if self.vid.isOpened():
            self.vid.release()
            
if __name__ == "__main__":
    
#Network    
    photo_path = "//192.168.100.87/sambashare" + '//' # root shared  
    #photo_path = "//192.168.100.87/sambashare" + '/snapshots/' # Ensure this directory exists
    #photo_path = "Z:/snapshots"  # Mapped Network Drive Location
    
#Local
    #photo_path = "./snapshots"  # Local Ditrctory >>>>Ensure this directory exists

    if not os.path.exists(photo_path):
        os.makedirs(photo_path)
    app = PhotoBoothApp(photo_path)


