<?php

/*
 * DataTables example server-side processing script.
 *
 * Please note that this script is intentionally extremely simple to show how
 * server-side processing can be implemented, and probably shouldn't be used as
 * the basis for a large complex system. It is suitable for simple use cases as
 * for learning.
 *
 * See http://datatables.net/usage/server-side for full details on the server-
 * side processing requirements of DataTables.
 *
 * @license MIT - http://datatables.net/license_mit
 */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */

// DB table to use
$table = 'vreg_list';

// Table's primary key
$primaryKey = 'ID';

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case simple
// indexes
$columns = array(
	
    array( 'db' => 'cardnumber', 'dt' => 0 ),
    array( 'db' => 'phonenumber', 'dt' => 1 ),
    array( 'db' => 'township', 'dt' => 2),
    array( 'db' => 'dept', 'dt' => 3 ),
    array( 'db' => 'startdatetime', 'dt' => 4 ),

    array(
        'db'        => 'pic_face',
        'dt'        => 5,
        'formatter' => function( $d, $row ) {
            //return '<i class="fas fa-user"></i>';

             return '<a onClick="showit(\''.$d.'\');" class="imgclass"><i class="fas fa-user"></i></a> ';
        }
    ),

     array(
        'db'        => 'pic_id',
        'dt'        => 6,
        'formatter' => function( $d, $row ) {
            //return '<i class="fas fa-id-card"></i>';

            return '<a onClick="showit(\''.$d.'\');" class="imgclass"><i class="fas fa-id-card"></i></a> ';

        }
    ),

      array(
        'db'        => 'pic_form',
        'dt'        => 7,
        'formatter' => function( $d, $row ) {
            //return '<a  onmouseover="bigImg(\''.$d.'\')" onmouseout="hideit()" ><i class="fas fa-file-alt"></i></a>';


            return '<a onClick="showit(\''.$d.'\');" class="imgclass"><i class="fas fa-file-alt"></i></a> ';

        }
    )


    
);

// SQL server connection information
$sql_details = array(
	'user' => 'vreg_user',
	'pass' => 'vreg_P@zz!',
	'db'   => 'vreg',
	'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */

require( 'ssp.class.php' );


echo json_encode(
	SSP::complex( $_GET, $sql_details, $table, $primaryKey, $columns )
);


